/* Class for the HE EU protocol
   Note: this protocol is different from the Home Easy UK protocol That's more like CoCo
   Home Easy EU is/was sold in Europe by ELRO with different brans
*/

#ifndef HE_h
#define HE_h

#define encodingBufferLength 8
#define TXPIN 11
#define StartBitHTime 260
#define StartBitLTime 8400
#define DataBit0HTime 260
#define DataBit0LTime 260
#define DataBit1HTime 260
#define DataBit1LTime 950


class HEClass  {

  private:
    int repeatcount = 3;
    //lookup  table for encoding; used in Encode Data
    //volatile
    byte encodingBuffer[encodingBufferLength];

    void EncodeData( int deviceCode, int command);
    void SendHeader();
    void SendData();
    void SendTrailer();
    void SendByte(byte abyte);
    void SendBit(int high , int low);
  public:
    void SendCommand(int deviceCode, int command);

};



void HEClass::SendCommand(int deviceCode, int command)
{
  pinMode(TXPIN, OUTPUT);
  for (int i = 0 ; i < repeatcount ; i++)
  {
    // encode the stuff
    EncodeData(deviceCode, command);
    SendHeader();
    SendData();
    SendTrailer();
  }
}

void HEClass::SendHeader()
{
  SendBit(StartBitHTime, StartBitLTime);
}

void HEClass::SendData()
{
  // we don't send the last byte; that's replaced by a single bit 1
  for (int i = 0; i < encodingBufferLength; i++)
  {
    SendByte(encodingBuffer[i]);
  }
  SendBit(DataBit1HTime, DataBit1LTime);
}

void  HEClass::SendTrailer()
{
}

void HEClass::SendByte(byte abyte)
{
  for (int i = 7; i >= 0; i--)
  {
    byte abit = bitRead(abyte, i);
    if (abit == 0)
    {
      SendBit(DataBit0HTime, DataBit0LTime);
    }
    else
    {
      SendBit(DataBit1HTime, DataBit1LTime);
    }
  }
}
void HEClass::SendBit(int high , int low)
{
  digitalWrite(TXPIN, HIGH);
  delayMicroseconds(high);
  digitalWrite(TXPIN, LOW);
  delayMicroseconds(low);
}

void HEClass::EncodeData( int deviceCode, int command)
{
  const byte lookup[] = { 0x7, 0xB, 0xD, 0xE, 0x13, 0x15, 0x16, 0x19, 0x1A, 0x1C, 0x3, 0x5, 0x6, 0x9, 0xA, 0xC };

  int commandValue = 0x1;
  if (command == 1)
  {
    commandValue |= 0x10;
  }

  encodingBuffer[0] = 0x0;
  encodingBuffer[1] = 0x0;
  encodingBuffer[2] = (byte)((deviceCode >> 12) & 0xF);
  encodingBuffer[3] = (byte)((deviceCode >> 8) & 0xF);
  encodingBuffer[4] = (byte)((deviceCode >> 4) & 0xF);
  encodingBuffer[5] = (byte)(deviceCode & 0xF);
  encodingBuffer[6] = (byte)(commandValue >> 4);
  encodingBuffer[7] = (byte)(commandValue & 0xF);

  for (int i = 0; i < encodingBufferLength; ++i)
  {
    encodingBuffer[i] = (byte)((lookup[encodingBuffer[i]] | 0x40) & 0x7F);
  }


  encodingBuffer[0] |= 0x80;

  uint64_t encodingValue = encodingBuffer[0];


  for (int i = 1; i < encodingBufferLength; ++i)
  {
    encodingValue = (encodingValue << 7) | encodingBuffer[i];
  }

  encodingValue = encodingValue << 7;
  int shift = 56;
  for (int i = 0; i < encodingBufferLength; ++i)
  {

    encodingBuffer[i] = (byte)(encodingValue >> shift);
    shift -= 8;
  }


}
#endif
