#include "HE.h"
#include <NewRemoteReceiver.h>

HEClass HEtx;

int anaddress = 0;
int acommand = 0;
boolean commandsend = false;

void setup() {
  Serial.begin(115200);
  // Initialize receiver on interrupt 0 (= digital pin 2), calls the callback "showCode"
  // after 2 identical codes have been received in a row. (thus, keep the button pressed
  // for a moment)
  //
  // See the interrupt-parameter of attachInterrupt for possible values (and pins)
  // to connect the receiver.
  NewRemoteReceiver::init(0, 2, showCode);

}

void loop() {
  if (commandsend)
  {
    // check for incoming data. No use for sending data if another device is sending data.
    if (NewRemoteReceiver::isReceiving()) return;

    // Disable the receiver; otherwise it might pick up the retransmit as well.
    NewRemoteReceiver::disable();
    
    HEtx.SendCommand(anaddress, acommand);
    commandsend = false;
    Serial.print("Command send to: ");
    Serial.print(anaddress);
    Serial.print(" with command: ");
    Serial.println(acommand);
    NewRemoteReceiver::enable();

  }

}

// Callback function is called only when a valid code is received.
void showCode(NewRemoteCode receivedCode) {
  // Note: interrupts are disabled. You can re-enable them if needed.
  // Print the received code.
  Serial.print("Addr ");
  //  Serial.print(receivedCode.address);

  // valid address between 1..6000
  anaddress = receivedCode.address % 6000;
  Serial.print(anaddress);
  if (receivedCode.groupBit) {
    Serial.print(" group");
  }
  else {
    Serial.print(" unit ");
    Serial.print(receivedCode.unit);
  }

  switch (receivedCode.switchType) {
    case NewRemoteCode::off: {
        Serial.print(" off");
        acommand = 0;
        break;
      }
    case NewRemoteCode::on: {
        Serial.print(" on");
        acommand = 1;
        break;
      }
    case NewRemoteCode::dim:
      Serial.print(" dim");
      break;


  }
  commandsend = true;
  if (receivedCode.dimLevelPresent) {
    Serial.print(", dim level: ");
    Serial.print(receivedCode.dimLevel);
  }

  Serial.print(", period: ");
  Serial.print(receivedCode.period);
  Serial.println("us.");
}


